// PageState.cpp : ʵļ
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageState.h"
#include "Include\CLS_NVDSDK_Interface.h"
#define CTRL_CARD		1
#define DECODE_CARD	2
#define CODING_CARD	3
// CPageState Ի

IMPLEMENT_DYNAMIC(CPageState, CDialog)

CPageState::CPageState(CWnd* pParent /*=NULL*/)
	:CLS_CBasePage(CPageState::IDD, pParent)
{
	m_iLogonID = -1;
}

CPageState::~CPageState()
{
}

void CPageState::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_DEC_ID, m_cboDecID);
	DDX_Control(pDX, IDC_CBO_CARDID, m_cboCardID);
	DDX_Control(pDX, IDC_EDT_STATE, m_edtState);
	DDX_Control(pDX, IDC_EDT_BINDWIDTH, m_edtBindWidth);
	DDX_Control(pDX, IDC_EDT_PROGRESS, m_edtProgress);
	DDX_Control(pDX, IDC_CBO_CARDID2, m_cboCard2);
	DDX_Control(pDX, IDC_EDT_TYPE, m_edtType2);
	DDX_Control(pDX, IDC_EDT_STATE2, m_edtState2);
	DDX_Control(pDX, IDC_EDT_BINDWIDTH2, m_edtBindWidth2);
	DDX_Control(pDX, IDC_EDT_DECCAP2, m_edtDecCap2);
	DDX_Control(pDX, IDC_EDT_PROGRESS2, m_edtProgress2);
	DDX_Control(pDX, IDC_EDT_DEVICE_STATE, m_edtDeviceState);
}


BEGIN_MESSAGE_MAP(CPageState, CDialog)
	ON_CBN_SELCHANGE(IDC_CBO_CARDID, &CPageState::OnCbnSelchangeCboCardid)
	ON_CBN_SELCHANGE(IDC_CBO_CARDID2, &CPageState::OnCbnSelchangeCboCardid2)
	ON_CBN_SELCHANGE(IDC_CBO_DEC_ID, &CPageState::OnCbnSelchangeCboDecId)
END_MESSAGE_MAP()

int CPageState::Initialize(TDECPARAM* _pdecParam)
{
	//LoadSurfaceResource();

	return TRUE;
}


// CPageState Ϣ

void CPageState::OnCbnSelchangeCboCardid()
{
	UpdateIpData();
}

void CPageState::OnCbnSelchangeCboCardid2()
{
	if(m_iLogonID < 0)
	{
		return;
	}
	int iRet = 0;
	int iResultSize = 0;
	ClusterCardState tClusterCardState = {0};
	tClusterCardState.iDevId = m_cboDecID.GetCurSel();
	tClusterCardState.iCardId = m_cboCard2.GetCurSel();
	iRet = DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_WORK_CARD_STATE, &tClusterCardState, sizeof(ClusterCardState), &iResultSize);
	if(0 == iRet)
	{
		SetDlgItemInt(IDC_EDT_BINDWIDTH2, tClusterCardState.iMaxCaptility);
		SetDlgItemInt(IDC_EDT_PROGRESS2, tClusterCardState.iProgress);
		if(1 == tClusterCardState.iState)
		{
			SetDlgItemText(IDC_EDT_STATE2, GetText(IDS_ONLINE));
		}
		else
		{
			SetDlgItemText(IDC_EDT_STATE2, GetText(IDS_OFFLINE));
		}
		if(CARD_TYPE_DECODE == tClusterCardState.iType)
		{
			SetDlgItemText(IDC_EDT_TYPE, GetText(IDS_DECODE_CARD));
		}
		else if(CARD_TYPE_ENCODE == tClusterCardState.iType)
		{
			SetDlgItemText(IDC_EDT_TYPE, GetText(IDS_CODING_CARD));
		}
		SetDlgItemInt(IDC_EDT_DECCAP2, tClusterCardState.iCurrentCaptility/10);
	}
}

void CPageState::OnCbnSelchangeCboDecId()
{
	if(m_iLogonID < 0)
	{
		return;
	}
	int iRet = 0;
	ClusterDeviceInfo tClusterDeviceInfo = {0};
	int iResultSize = 0;
	ClusterCardState tClusterCardState = {0};
	tClusterDeviceInfo.iDevId = m_cboDecID.GetCurSel();
	DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_DEVICE_INFO, &tClusterDeviceInfo, sizeof(ClusterDeviceInfo), &iResultSize);
	m_cboCardID.ResetContent();
	for(int i=0; i < tClusterDeviceInfo.iCtrlCardNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboCardID.AddString(strNo);
	}
	m_cboCardID.SetCurSel(0);
	m_cboCard2.ResetContent();
	for(int i = 0; i < tClusterDeviceInfo.iSlotdNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboCard2.AddString(strNo);
	}
	m_cboCard2.SetCurSel(0);
	iRet = DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_DEVICE_STATE, &tClusterCardState, sizeof(ClusterCardState), &iResultSize);
	if(0 == iRet)
	{
		if(1 == tClusterCardState.iState)
		{
			SetDlgItemText(IDC_EDT_DEVICE_STATE, GetText(IDS_ONLINE));
		}
		else
		{
			SetDlgItemText(IDC_EDT_DEVICE_STATE, GetText(IDS_OFFLINE));
		}
	}

	UpdateIpData();
}

BOOL CPageState::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	if(m_iLogonID < 0)
	{
		return FALSE;
	}
	ClusterDeviceInfo tClusterDeviceInfo = {0};
	ClusterInfo tClusterInfo = {0};
	int iResultSize = 0;
	//DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_DEVICE_INFO, &tClusterDeviceInfo, sizeof(ClusterDeviceInfo), &iResultSize);
	DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_CLUSTERINFO, &tClusterInfo, sizeof(ClusterInfo), &iResultSize);
	for (int i=0; i < tClusterInfo.iDevNum; i++)
	{
		CString strNo;
		strNo.Format("%d",i);
		m_cboDecID.AddString(strNo);
	}
	m_cboDecID.SetCurSel(0);

	OnCbnSelchangeCboDecId();
	OnCbnSelchangeCboCardid();
	OnCbnSelchangeCboCardid2();
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CPageState::UpdateIpData()
{
	if(m_iLogonID < 0)
	{
		return;
	}
	int iRet = 0;
	int iResultSize = 0;
	ClusterCardState tClusterCardState = {0};
	tClusterCardState.iDevId = m_cboDecID.GetCurSel();
	tClusterCardState.iCardId = m_cboCardID.GetCurSel();
	//tClusterCardState.iType = CTRL_CARD;
	iRet = DEC_ClientGetClusterConfig(m_iLogonID, CLUSTER_CONTROL_CARD_STATE, &tClusterCardState, sizeof(ClusterCardState), &iResultSize);
	if(0 == iRet)
	{
		SetDlgItemInt(IDC_EDT_BINDWIDTH, tClusterCardState.iMaxCaptility);
		SetDlgItemInt(IDC_EDT_PROGRESS, tClusterCardState.iProgress);
		if(1 == tClusterCardState.iState)
		{
			SetDlgItemText(IDC_EDT_STATE, GetText(IDS_ONLINE));
		}
		else
		{
			SetDlgItemText(IDC_EDT_STATE, GetText(IDS_OFFLINE));
		}
	}
}
